/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet.xport.stream;

import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.connmgr.ConnectionGroup;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.tasklet.impl.TaskletInitialRequest;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ControlRequest;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ControlResponse;
import com.ibm.hwmca.fw.tasklet.xport.ConversationComponent;
import com.ibm.hwmca.fw.tasklet.xport.TaskletCommunicationClient;
import com.ibm.hwmca.fw.tasklet.xport.TaskletNewConnectionParms;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.standalone.StandaloneConnectionFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class StreamClient
implements TaskletCommunicationClient {
    private static final String TRACE_MASKT = "XTSKCSCT";
    private static final String TRACE_MASKF = "XTSKCSCF";
    private static final String TRACE_MASKD = "XTSKCSCD";
    private ConnectionGroup connectionGroup = null;
    protected ObjectInputStream dataIn = null;
    protected ObjectOutputStream dataOut = null;
    protected ObjectInputStream controlIn = null;
    protected ObjectOutputStream controlOut = null;
    protected int id = -1;

    public StreamClient(ClientUserContext clientUserContext) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] StreamClient() <ctor> clientUserContext=" + clientUserContext);
        try {
            String standalone;
            try {
                standalone = System.getProperty("STANDALONE_TASK", "NO");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] caught exception reading system property; assuming not standalone");
                standalone = "NO";
            }
            if ("YES".equals(standalone)) {
                Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] using standalone connections ");
                this.connectionGroup = StandaloneConnectionFactory.getClientConnections();
            } else {
                Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] using regular connections ");
                if (clientUserContext != null) {
                    Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] Using provided clientUserContext object.");
                    this.connectionGroup = clientUserContext.getConnectionFactory().getConnections("tasklet", 2, null);
                } else {
                    Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] Using clientUserContext object from ConnectionFactory static method.");
                    this.connectionGroup = ConnectionFactory.getUserConnectionFactory().getConnections("tasklet", 2, null);
                }
            }
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] Connection obtained, setting up control and data sockets.");
            this.dataOut = new ObjectOutputStream(this.connectionGroup.getConnections()[1].getSocket().getOutputStream());
            this.dataOut.flush();
            this.dataIn = new ObjectInputStream(this.connectionGroup.getConnections()[1].getSocket().getInputStream());
            this.controlOut = new ObjectOutputStream(this.connectionGroup.getConnections()[0].getSocket().getOutputStream());
            this.controlOut.flush();
            this.controlIn = new ObjectInputStream(this.connectionGroup.getConnections()[0].getSocket().getInputStream());
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] <init>  Error in tasklet communication layer (client side)." + e);
            this.terminate();
            throw new TaskletException(e);
        }
    }

    public StreamClient() throws TaskletException {
        this(null);
    }

    protected Object readResponse(ObjectInputStream inStream) throws TaskletException {
        try {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] readResponse() entry");
            Object response = inStream.readObject();
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] obtained response:: " + response);
            if (response instanceof TaskletException) {
                Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] response was a tasklet exception, throwing...");
                throw (TaskletException)response;
            }
            return response;
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] IOException reading response\n");
            this.terminate();
            throw new TaskletException(e);
        }
        catch (TaskletException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] readResponse() Exception in tasklet communication layer (client side)." + e);
            this.terminate();
            throw new TaskletException(e);
        }
    }

    public boolean isAuthenticated() {
        return this.connectionGroup != null ? this.connectionGroup.isAuthenticated() : false;
    }

    public Connection connect(String name, ConversationComponent initData) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] connect(" + name + "," + initData + ")");
        try {
            String standalone;
            try {
                standalone = System.getProperty("STANDALONE_TASK", "NO");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] caught exception reading system property; assuming not standalone");
                Trace.trace(TRACE_MASKF, e);
                standalone = "NO";
            }
            if ("YES".equals(standalone)) {
                throw new UnsupportedOperationException("New connections not allowed in stand alone mode");
            }
            return ConnectionFactory.getUserConnectionFactory().getNewConnection(this.connectionGroup, new TaskletNewConnectionParms(name, initData));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] connect() Error in tasklet communication layer (client side)." + e);
            this.terminate();
            throw new TaskletException(e);
        }
    }

    public TaskletResponse init(TaskletInitialRequest initialRequest) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] init(" + initialRequest + ")");
        try {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] init() dataOut.write() " + initialRequest);
            this.dataOut.reset();
            this.dataOut.writeObject(initialRequest);
            this.dataOut.flush();
            return (TaskletResponse)this.readResponse(this.dataIn);
        }
        catch (TaskletException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] init() Error in tasklet communication layer (client side).");
            this.terminate();
            throw new TaskletException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws TaskletException {
        Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] terminate()");
        try {
            this.connectionGroup.closeConnections();
        }
        catch (Exception exception) {
        }
        finally {
            this.connectionGroup = null;
        }
    }

    public void postControlRequest(ControlRequest request) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] postControlRequest(" + request + ")");
        try {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] PCR() dataOut.write() " + request);
            this.dataOut.reset();
            this.dataOut.writeObject(request);
            this.dataOut.flush();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] postControlRequest() Error in tasklet communication layer (client side).");
            this.terminate();
            throw new TaskletException(e);
        }
    }

    public ControlRequest getControlRequest(ControlResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] getControlRequest(" + response + ")");
        try {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] GCR() controlOut.write() " + response);
            this.controlOut.reset();
            this.controlOut.writeObject(response);
            this.controlOut.flush();
            ControlRequest request = (ControlRequest)this.readResponse(this.controlIn);
            return request;
        }
        catch (TaskletException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] getControlRequest() Error in tasklet communication layer (client side).");
            this.terminate();
            throw new TaskletException(e);
        }
    }

    public TaskletResponse request(TaskletRequest request) throws TaskletException {
        TaskletResponse response = null;
        Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] request(" + request + ")");
        try {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] request() dataOut.write() " + request);
            this.dataOut.reset();
            this.dataOut.writeObject(request);
            this.dataOut.flush();
            response = (TaskletResponse)this.readResponse(this.dataIn);
        }
        catch (TaskletException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] request() Error in tasklet communication layer (client side).");
            this.terminate();
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKF, "[StreamClient:" + this.id + "] request() returning response to caller: " + response);
        return response;
    }

    public void setTraceId(int id) {
        Trace.trace(TRACE_MASKF, "[StreamClient:" + id + "] setTraceId(" + id + ")");
        this.id = id;
    }
}

